//+------------------------------------------------------------------+
//|                                                  LSMA of RVI.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property  copyright "mladen"
#property  link      ""

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1  Lime

//
//
//
//
//

extern int    RVIPeriod   = 10;
extern int    LSMAPeriod  = 14;

//
//
//
//
//

double lsma[];
double rvi[];
double buffer1[];
double buffer2[];

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   IndicatorBuffers(4);
      SetIndexBuffer(0,lsma);
      SetIndexBuffer(1,rvi);
      SetIndexBuffer(2,buffer1);
      SetIndexBuffer(3,buffer2);
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{ 
   int counted_bars=IndicatorCounted();
   int limit,i;

   if(counted_bars < 0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = Bars-counted_bars;

   //
   //
   //
   //
   //
   
   for(i=limit; i>=0; i--)
   {
      buffer1[i] = ((Close[i]-Open[i])+2.0*(Close[i+1]-Open[i+1])+2.0*(Close[i+2]-Open[i+2])+(Close[i+3]-Open[i+3]))/6.0;
      buffer2[i] = ((High[i]-Low[i])  +2.0*(High[i+1]-Low[i+1])  +2.0*(High[i+2]-Low[i+2])  +(High[i+3]-Low[i+3])  )/6.0;
      
      //
      //
      //
      //
      //
      
      double num   = 0.0; 
      double denom = 0.0;
         for(int k=0; k<RVIPeriod; k++)
         {
            num   += buffer1[i+k];
            denom += buffer2[i+k];
         }
         if(denom!=0.0)
               rvi[i] = num/denom;
         else  rvi[i] = 0.0;
   }   
   for(i=limit; i>=0; i--)
      lsma[i] = 3.0*iMAOnArray(rvi,0,LSMAPeriod,0,MODE_LWMA,i)-
                2.0*iMAOnArray(rvi,0,LSMAPeriod,0,MODE_SMA ,i);
      
   //
   //
   //
   //
   //
   
   return(0);
}